import packtalkDucatiIcon from 'resources/images/models/packtalkducati.png';
import packtalkBoldIcon from 'resources/images/models/packtalkbold.png';
import spiritIcon from 'resources/images/models/spirit.png';
import frc2xIcon from 'resources/images/models/frc2x.png';
import frc4xIcon from 'resources/images/models/frc4x.png';
import packtalkEdgeIcon from 'resources/images/models/edge.png';
import packtalkEdgeDucatiIcon from 'resources/images/models/edge_ducati.png';
import packtalkEdgeKTMIcon from 'resources/images/models/edge_ktm.png';
import packtalkEdgeHondaIcon from 'resources/images/models/edge_honda.png';
import packtalkBlackIcon from 'resources/images/models/packtalkblack.png';
import packtalkSlimIcon from 'resources/images/models/packtalkslim.png';
import packtalkIcon from 'resources/images/models/packtalk.png';
import smartHIcon from 'resources/images/models/smartH.png';
import smartpackIcon from 'resources/images/models/smartpack.png';
import freecom4plusIcon from 'resources/images/models/freecom4+.png';
import freecom4Icon from 'resources/images/models/freecom4.png';
import freecom2plusIcon from 'resources/images/models/freecom2+.png';
import freecom2Icon from 'resources/images/models/freecom2.png';
import freecom1plusIcon from 'resources/images/models/freecom1+.png';
import freecom1Icon from 'resources/images/models/freecom1.png';
import terranoXTIcon from 'resources/images/models/terrano.png';
import freecomSoloIcon from 'resources/images/models/freecomsolo.png';
import packtalkSlimAGVIcon from 'resources/images/models/packtalkslimagv.png';
import mclarenIntercomIcon from 'resources/images/models/mclaren_intercom.png';
import ptOutdoorIcon from 'resources/images/models/pt_outdoor.png';
import ptOutdoorStudentIcon from 'resources/images/models/pt_outdoor_student.png';
import ptEdgeSimpsonIcon from 'resources/images/models/pt_edge_simpson.png';
import ptCustomIcon from 'resources/images/models/pt_custom.png';
import ptNeo from 'resources/images/models/pt_neo.png';
import orv from 'resources/images/models/orv.png';
import deltaV from 'resources/images/models/delta_v.png';
import ucsLS2 from 'resources/images/models/ucs_ls2.png';
import harleyEdge from 'resources/images/models/harley_edge.png';
import harleyFC4X from 'resources/images/models/harley_frc4x.png';
import harleyFC2X from 'resources/images/models/harley_frc2x.png';
import ucs509Icon from 'resources/images/models/ucs_509.png';
import shockwaveMeshIcon from 'resources/images/models/shockwave_mesh.png';
import ptProIcon from 'resources/images/models/pt_pro.png';
import giviSpiritIcon from 'resources/images/models/givi_spirit.png';
import schuberthIcon from 'resources/images/models/schuberth_sc_edge.png';
import defaultIcon from 'resources/images/models/default_unit.svg';
import { MODELS } from 'library/headset/consts';

export function modelToImage(modelName) {
    if (modelName === MODELS.PRO1) return defaultIcon;
    if (modelName === MODELS.PACKTALK_BOLD_JBL) return packtalkBoldIcon;
    if (modelName === MODELS.PACKTALK_DUCATI) return packtalkDucatiIcon;
    if (modelName === MODELS.PACKTALK_BLACK) return packtalkBlackIcon;
    if (modelName === MODELS.PACKTALK_SLIM_JBL) return packtalkSlimIcon;
    if (modelName === MODELS.PACKTALK_BOLD) return packtalkBoldIcon;
    if (modelName === MODELS.PACKTALK_SLIM) return packtalkSlimIcon;
    if (modelName === MODELS.PACKTALK_SKI) return packtalkIcon;
    if (modelName === MODELS.PACKTALK) return packtalkIcon;
    if (modelName === MODELS.SMART_H) return smartHIcon;
    if (modelName === MODELS.SMARTPACK) return smartpackIcon;
    if (modelName === MODELS.FREECOM4PLUS) return freecom4plusIcon;
    if (modelName === MODELS.FREECOM4PLUSCR) return freecom4plusIcon;
    if (modelName === MODELS.FREECOM4) return freecom4Icon;
    if (modelName === MODELS.FREECOM2PLUS) return freecom2plusIcon;
    if (modelName === MODELS.FREECOM2) return freecom2Icon;
    if (modelName === MODELS.FREECOM1PLUS) return freecom1plusIcon;
    if (modelName === MODELS.FREECOM1FM) return freecom1Icon;
    if (modelName === MODELS.FREECOM1) return freecom1Icon;
    if (modelName === MODELS.TERRANOXT) return terranoXTIcon;
    if (modelName === MODELS.FREECOM_SOLO) return freecomSoloIcon;
    if (modelName === MODELS.PACKTALK_SLIM_AGV) return packtalkSlimAGVIcon;
    if (modelName === MODELS.MCLAREN_INTERCOM) return mclarenIntercomIcon;
    if (modelName === MODELS.PACKTALK_LOUIS) return packtalkBoldIcon;
    if (modelName === MODELS.PACKTALK_BOLD_JBL_ICS00177)
        return packtalkBoldIcon;
    if (modelName === MODELS.SKI_II_SINGLE_PACK) return packtalkIcon;
    if (modelName === MODELS.PACKTALK_BLACK_ICS00177) return packtalkBlackIcon;
    if (modelName === MODELS.PACKTALK_SLIM_JBL_ICS00177)
        return packtalkSlimIcon;
    if (modelName === MODELS.PACKTALK_SLIM_MCLAREN_ICS00177)
        return mclarenIntercomIcon;
    if (modelName === MODELS.PACKTALK_BOLD_LOUIS_NEW_FM_ICS)
        return packtalkBoldIcon;
    if (modelName === MODELS.SPIRIT) return spiritIcon;
    if (modelName === MODELS.SPIRIT_HD) return spiritIcon;
    if (modelName === MODELS.FRC2X) return frc2xIcon;
    if (modelName === MODELS.FRC4X) return frc4xIcon;
    if (modelName === MODELS.PACKTALK_EDGE) return packtalkEdgeIcon;
    if (modelName === MODELS.PACKTALK_EDGE_DUCATI)
        return packtalkEdgeDucatiIcon;
    if (modelName === MODELS.PACKTALK_EDGE_KTM) return packtalkEdgeKTMIcon;
    if (modelName === MODELS.PACKTALK_EDGE_HONDA) return packtalkEdgeHondaIcon;
    if (modelName === MODELS.PT_OUTDOOR_CONSUMER) return ptOutdoorIcon;
    if (modelName === MODELS.PT_OUTDOOR_INSTRUCTOR) return ptOutdoorIcon;
    if (modelName === MODELS.PT_OUTDOOR_STUDENT) return ptOutdoorStudentIcon;
    if (modelName === MODELS.PT_EDGE_SIMPSON) return ptEdgeSimpsonIcon;
    if (modelName === MODELS.PT_CUSTOM) return ptCustomIcon;
    if (modelName === MODELS.PACKTALK_NEO) return ptNeo;
    if (modelName === MODELS.PACKTALK_ORV) return orv;
    if (modelName === MODELS.PACKTALK_DELTA_V) return deltaV;
    if (modelName === MODELS.UCS_LS2) return ucsLS2;
    if (modelName === MODELS.PACKTALK_EDGE_HARLEY) return harleyEdge;
    if (modelName === MODELS.FREECOM4X_HARLEY) return harleyFC4X;
    if (modelName === MODELS.FREECOM2X_HARLEY) return harleyFC2X;
    if (modelName === MODELS.PACKTALK_NEO_SE) return ptNeo;
    if (modelName === MODELS.PACKTALK_EDGE_NO_FPGA) return packtalkEdgeIcon;
    if (modelName === MODELS.PACKTALK_PRO) return ptProIcon;
    if (modelName === MODELS.FC_MOTO_UCS) return ucsLS2;
    if (modelName === MODELS.GIVI_UCS) return giviSpiritIcon;
    if (modelName === MODELS.SHOCKWAVE_MESH) return shockwaveMeshIcon;
    if (modelName === MODELS.M509_UCS_SPIRIT) return ucs509Icon;
    if (modelName === MODELS.PACKTALK_NEO_NO_FPGA) return ptNeo;
    if (modelName === MODELS.PACKTALK_NEO_LOUIS) return ptCustomIcon;
    if (modelName === MODELS.PACKTALK_OUTDOOR_FREEJUMP) return ptOutdoorIcon;
    if (modelName === MODELS.SCHUBERTH_SC_EDGE) return schuberthIcon;

    return defaultIcon;
}

export function modelToName(modelName) {
    if (!modelName) return;

    if (modelName === MODELS.FREECOM_SOLO) return 'FREECOM Solo';
    if (modelName === MODELS.FREECOM4PLUSCR) return 'FREECOM4+';
    if (modelName === MODELS.FREECOM4PLUS) return 'FREECOM4+';
    if (modelName === MODELS.FREECOM2PLUS) return 'FREECOM2+';
    if (modelName === MODELS.FREECOM1PLUS) return 'FREECOM1+';
    if (modelName === MODELS.PACKTALK_BOLD) return 'PACKTALK BOLD';
    if (modelName === MODELS.PACKTALK_BOLD_JBL) return 'PACKTALK BOLD JBL';
    if (modelName === MODELS.PACKTALK_SLIM) return 'PACKTALK SLIM';
    if (modelName === MODELS.PACKTALK_SKI) return 'PACKTALK SKI';
    if (modelName === MODELS.PACKTALK_SLIM_JBL) return 'PACKTALK SLIM JBL';
    if (modelName === MODELS.PACKTALK_DUCATI) return 'PACKTALK Bold - Ducati';
    if (modelName === MODELS.PACKTALK_BLACK) return 'PACKTALK BLACK';
    if (modelName === MODELS.TERRANOXT) return 'TERRANO XT';
    if (modelName === MODELS.PACKTALK_SLIM_AGV) return 'INSYDE';
    if (modelName === MODELS.MCLAREN_INTERCOM) return 'PACKTALK SLIM';
    if (modelName === MODELS.PACKTALK_LOUIS) return 'PACKTALK LOUIS';
    if (modelName === MODELS.PACKTALK_BOLD_JBL_ICS00177)
        return 'PACKTALK BOLD JBL';
    if (modelName === MODELS.SKI_II_SINGLE_PACK)
        return 'PACKTALK SKI II SINGLE PACK';
    if (modelName === MODELS.PACKTALK_BLACK_ICS00177) return 'PACKTALK BLACK';
    if (modelName === MODELS.PACKTALK_SLIM_JBL_ICS00177)
        return 'PACKTALK SLIM JBL';
    if (modelName === MODELS.PACKTALK_SLIM_MCLAREN_ICS00177)
        return 'PACKTALK SLIM';
    if (modelName === MODELS.PACKTALK_BOLD_LOUIS_NEW_FM_ICS)
        return 'PACKTALK LOUIS';
    if (modelName === MODELS.SPIRIT) return 'SPIRIT';
    if (modelName === MODELS.SPIRIT_HD) return 'SPIRIT HD';
    if (modelName === MODELS.FRC2X) return 'FREECOM 2X';
    if (modelName === MODELS.FRC4X) return 'FC4X';
    if (modelName === MODELS.PACKTALK_EDGE) return 'PACKTALK EDGE';
    if (modelName === MODELS.PACKTALK_EDGE_DUCATI)
        return 'PACKTALK EDGE DUCATI';
    if (modelName === MODELS.PACKTALK_EDGE_KTM) return 'PACKTALK EDGE KTM';
    if (modelName === MODELS.PACKTALK_EDGE_HONDA) return 'PACKTALK EDGE HONDA';
    if (modelName === MODELS.PT_OUTDOOR_CONSUMER) return 'PT OUTDOOR CONSUMER';
    if (modelName === MODELS.PT_OUTDOOR_INSTRUCTOR)
        return 'PT OUTDOOR INSTRUCTOR';
    if (modelName === MODELS.PT_OUTDOOR_STUDENT) return 'PT OUTDOOR STUDENT';
    if (modelName === MODELS.PT_CUSTOM) return 'PT CUSTOM';
    if (modelName === MODELS.PT_EDGE_SIMPSON) return 'PACKTALK EDGE SIMPSON';
    if (modelName === MODELS.PACKTALK_NEO) return 'PACKTALK NEO';
    if (modelName === MODELS.PACKTALK_ORV) return 'PACKTALK ORV';
    if (modelName === MODELS.PACKTALK_DELTA_V) return 'DELTA V';
    if (modelName === MODELS.UCS_LS2) return 'LS2';
    if (modelName === MODELS.PACKTALK_EDGE_HARLEY)
        return 'PACKTALK HARLEY DAVIDSON';
    if (modelName === MODELS.FREECOM4X_HARLEY)
        return 'FREECOM 4X HARLEY DAVIDSON';
    if (modelName === MODELS.FREECOM2X_HARLEY)
        return 'FREECOM 2X HARLEY DAVIDSON';
    if (modelName === MODELS.PACKTALK_NEO_SE) return 'PACKTALK SPECIAL EDITION';
    if (modelName === MODELS.PACKTALK_EDGE_NO_FPGA) return 'PACKTALK EDGE';
    if (modelName === MODELS.PACKTALK_PRO) return 'PACKTALK PRO';
    if (modelName === MODELS.FC_MOTO_UCS) return 'FC4X';
    if (modelName === MODELS.GIVI_UCS) return 'GIVI SPIRIT';
    if (modelName === MODELS.SHOCKWAVE_MESH) return 'SHOCKWAVE MESH';
    if (modelName === MODELS.M509_UCS_SPIRIT) return '509 UCS Spirit';
    if (modelName === MODELS.PACKTALK_NEO_NO_FPGA) return 'PACKTALK NEO';
    if (modelName === MODELS.PACKTALK_NEO_LOUIS) return 'PACKTALK LOUIS';
    if (modelName === MODELS.PACKTALK_OUTDOOR_FREEJUMP)
        return 'OUTDOOR FREEJUMP';
    if (modelName === MODELS.SCHUBERTH_SC_EDGE) return 'SC EDGE';

    return modelName.toUpperCase();
}
